<?php

namespace Ptb\Accuzip\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Storage;
use Ptb\Accuzip\AccuzipConnector;
use Ptb\Accuzip\Actions\UploadAndProcessMailFile;
use Ptb\Accuzip\Data\ColumnMapData;
use Ptb\Accuzip\Data\MailingAgentData;
use Ptb\Accuzip\Data\PermitHolderData;
use Ptb\Accuzip\Data\PreparedForData;
use Ptb\Accuzip\Enums\QUOTE\MailPieceSize;
use Ptb\Accuzip\Enums\QUOTE\PresortClass;
use Ptb\Accuzip\Enums\QUOTE\TrayType;
use ReflectionException;
use Saloon\Exceptions\InvalidResponseClassException;
use Saloon\Exceptions\PendingRequestException;

class AccuzipTemplate extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'description' => 'string',
        'do_cass' => 'boolean',
        'do_ncoa' => 'boolean',
        'do_dups' => 'boolean',
        'do_presort' => 'boolean',
        'drop_zip' => 'integer',
        'presort_class' => PresortClass::class,
        'piece_size' => MailPieceSize::class,
        'piece_height' => 'decimal:4',
        'piece_length' => 'decimal:4',
        'piece_thickness' => 'decimal:4',
        'piece_weight' => 'decimal:4',
        'permit_holder' => PermitHolderData::class,
        'mailing_agent' => MailingAgentData::class,
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'print_barcode' => 'boolean',
        'print_imb' => 'boolean',
        'print_reverse' => 'boolean',
        'include_crrt' => 'boolean',
        'include_non_zip4' => 'boolean',
        'column_mapping' => ColumnMapData::class,
        'prepared_for' => PreparedForData::class,
        'political_mail' => 'boolean',
        'election_mail' => 'boolean',
        'maildat_pdr' => 'boolean',
        'coa_flag_only' => 'boolean',
        'filter_ncoa_01' => 'boolean',
        'filter_ncoa_02' => 'boolean',
        'filter_ncoa_03' => 'boolean',
        'filter_ncoa_04' => 'boolean',
        'filter_ncoa_05' => 'boolean',
        'filter_ncoa_06' => 'boolean',
        'filter_ncoa_07' => 'boolean',
        'filter_ncoa_08' => 'boolean',
        'filter_cass_02' => 'boolean',
        'filter_cass_03' => 'boolean',
        'filter_cass_04' => 'boolean',
        'filter_cass_05' => 'boolean',
        'filter_cass_06' => 'boolean',
        'filter_cass_07' => 'boolean',
        'filter_cass_08' => 'boolean',
        'filter_cass_09' => 'boolean',
        'filter_cass_10' => 'boolean',
        'tray_type' => TrayType::class,
    ];

    public function quotes(): HasMany
    {
        return $this->hasMany(AccuzipQuote::class, 'accuzip_template_id', 'id');
    }
}
