<?php

namespace Ptb\Accuzip\Requests\CASS_NCOA_PRESORT;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class DoCertification extends Request
{

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/CASS-NCOA-PRESORT";
    }

    /**
     * Use this web service call to clean and standardize all of the addresses in the file; process the names and
     * addresses that have been previously CASS Certified, through our Licensed NCOALink process for Change of
     * Address matching; remove duplicate records from the CASS Certified and NCOALink Certified file; process
     * addresses that have been CASS Certified through our Cloud Presort engine to claim the lowest postage rates;
     * generate the USPS Documentation in PDF format; and generate the print-ready CSV file. This web service
     * performs all size processes with one call.
     *
     * Before you can use this REST API call, you must first upload the file (see Upload File) and PUT the JSON object
     * (see Update Quote) that will contain all of the mail-piece characteristics and mailer information (TBA).
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
