<?php

namespace Ptb\Accuzip\Enums\QUOTE;

enum MailPieceSize: string
{
    case Card = 'CARD';
    case Letter = 'LETTER';
    case Flat = 'FLAT';
    case Parcel = 'PARCEL';
    case ManifestCard = 'MANIFEST CARD';
    case ManifestLetter = 'MANIFEST LETTER';
    case ManifestFlat = 'MANIFEST FLAT';
    
    public function description(): string
    {
        return match($this) {
            MailPieceSize::Card => 'Postcard',
            MailPieceSize::Letter => 'Letter',
            MailPieceSize::Flat => 'Flat',
            MailPieceSize::Parcel => 'Parcel',
            MailPieceSize::ManifestCard => 'Manifest Postcard',
            MailPieceSize::ManifestLetter => 'Manifest Letter',
            MailPieceSize::ManifestFlat => 'Manifest Flat',
        };
    }

    public static function toArray(): array
    {
        return [
            MailPieceSize::Card->value => 'Postcard',
            MailPieceSize::Letter->value => 'Letter',
            MailPieceSize::Flat->value => 'Flat',
            MailPieceSize::Parcel->value => 'Parcel',
            MailPieceSize::ManifestCard->value => 'Manifest Postcard',
            MailPieceSize::ManifestLetter->value => 'Manifest Letter',
            MailPieceSize::ManifestFlat->value => 'Manifest Flat',
        ];
    }    
}