<?php

namespace Ptb\Accuzip\Requests\DUPS;

use Ptb\Accuzip\Enums\TaskType;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class DoDetection extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::GET;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->guid}/DUPS/{$this->duplicateSubType}";
    }

    /**
     * Detect duplicates by Address and, if exists, Company
     *
     * @return $this
     */
    public function byAddressOnly(): static
    {
        $this->duplicateSubType = '01';

        return $this;
    }

    /**
     * Detect duplicates by First and Last Name
     *
     * @return $this
     */
    public function byFirstLast(): static
    {
        $this->duplicateSubType = '02';

        return $this;
    }

    /**
     * Detect duplicates by Household Name
     *
     * @return $this
     */
    public function byHousehold(): static
    {
        $this->duplicateSubType = '03';

        return $this;
    }

    /**
     * @var string
     */
    private string $duplicateSubType;

    /**
     * Use this web service call to remove duplicate records from the CASS Certified and NCOALink Certified file. This
     * will ensure that only one mail-piece is mailed to an address, person, household or company.
     *
     * @param string $guid
     */
    public function __construct(
        private readonly string $guid,
    )
    {}
}
