<?php

namespace Ptb\Accuzip\Jobs\NCOA;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Ptb\Accuzip\AccuzipConnector;
use Ptb\Accuzip\Models\AccuzipQuote;
use Ptb\Accuzip\Requests\NCOA\DoCertification;
use ReflectionException;
use Saloon\Exceptions\InvalidResponseClassException;
use Saloon\Exceptions\PendingRequestException;

class Certify implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @param AccuzipQuote $quote
     */
    public function __construct(
        private readonly AccuzipQuote $quote
    )
    {}

    /**
     * @param AccuzipConnector $service
     * @return void
     * @throws ReflectionException
     * @throws InvalidResponseClassException
     * @throws PendingRequestException
     */
    public function handle(
        AccuzipConnector $service,
    ): void
    {
        $response = $service->send(request: $this->buildRequest());
        if ($response->failed()) {
            $response->throw();
        }
    }

    /**
     * @return DoCertification
     */
    protected function buildRequest(): DoCertification
    {
        return new DoCertification(guid: $this->quote->guid);
    }
}
