<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accuzip_quotes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('accuzip_template_id')->constrained('accuzip_templates');
            $table->string('source_disk')->default('public');
            $table->string('source_filepath');
            $table->string('print_ready_filepath')->nullable();
            $table->string('usps_pdf_filepath')->nullable();
            $table->string('maildat_filepath')->nullable();
            $table->string('guid')->nullable(); // not populated until upload complete=true
            $table->boolean('do_presort')->default(1);
            $table->boolean('do_cass')->default(1);
            $table->boolean('do_ncoa')->default(1);
            $table->boolean('do_dups')->default(1);

            $table->integer('total_records')->default(0);
            $table->integer('total_presort_records')->default(0);

            $table->boolean('upload_complete')->default(0);
            $table->boolean('cass_certification_complete')->default(0);
            $table->boolean('ncoa_link_certification_complete')->default(0);
            $table->boolean('duplicate_detection_complete')->default(0);
            $table->boolean('presort_complete')->default(0);
            $table->timestamp('mail_date')->nullable();
            $table->string('statement_number')->nullable();

            $table->decimal('postage', 12, 2)->default(0);
            $table->decimal('postage_saved', 12, 2)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accuzip_quotes');
    }
};
