<?php

namespace Ptb\Accuzip\Requests\QUOTE;

use Illuminate\Support\Carbon;
use Ptb\Accuzip\Data\ColumnMapData;
use Ptb\Accuzip\Data\MailingAgentData;
use Ptb\Accuzip\Data\PermitHolderData;
use Ptb\Accuzip\Enums\QUOTE\MailPieceSize;
use Ptb\Accuzip\Enums\QUOTE\PresortClass;
use Ptb\Accuzip\Models\AccuzipQuote;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class PutQuote extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * Define the HTTP method
     *
     * @var Method
     */
    protected Method $method = Method::PUT;

    /**
     * Define the endpoint for the request
     *
     * @return string
     */
    public function resolveEndpoint(): string
    {
        return "/servoy-service/rest_ws/ws_360/v2_0/job/{$this->quote->guid}/QUOTE";
    }

    /**
     * Define the default body for the request
     *
     * @return array
     */
    public function defaultBody(): array
    {
        return array_filter(
            array_merge_recursive(
                [
                    'presort_class' => $this->quote->presort_class->value,
                    'drop_zip' => (string)$this->quote->drop_zip,
                    'mail_piece_size' => $this->quote->piece_size->value,
                    'mailing_date' => $this->quote->mail_date->format('m/d/Y'),
                    'piece_height' => number_format($this->quote->piece_height, 2),
                    'piece_length' => number_format($this->quote->piece_length, 2),
                    'thickness_value' => number_format($this->quote->piece_thickness, 4),
                    'thickness_based_on' => '1',
                    'pallets' => '1',
                    'calculate_container_volume' => '1',
                    'tray_type' => $this->quote->tray_type?->value ?? null,
                    'print_barcode' => $this->quote->print_barcode ? '1' : '0',
                    'print_imb' => $this->quote->print_imb ? '1' : '0',
                    'print_reverse' => $this->quote->print_reverse ? '1' : '0',
                    'machinability' => $this->quote->machinability,
                    'weight_value' => number_format($this->quote->piece_weight, 4),
                    'weight_unit' => 'OUNCES',
                    'weight_based_on' => '1',
                    'mail_permit_type' => $this->quote->mail_permit_type,
                    'mail_pay_method' => $this->quote->mail_pay_method,
                    'include_non_zip4' => $this->quote->include_non_zip4 ? '1' : '0',
                    'include_crrt' => $this->quote->include_crrt ? '1' : '0',
                    'political_mail' => $this->quote->political_mail ? '1': '0',
                    'election_mail' => $this->quote->election_mail ? '1' : '0',
                    'maildat_pdr' => $this->quote->maildat_pdr ? '1': '0',
                    'statement_number' => $this->quote->statement_number,
                    'max1ft' => $this->quote->max1ft,
                    'min1ft' => $this->quote->min1ft,
                    'max2ft' => $this->quote->max2ft,
                    'min2ft' => $this->quote->min2ft,
                    'coa_flag_only' => $this->quote->coa_flag_only ? '1' : '0',
                    'filter_ncoa_01' => $this->quote->filter_ncoa_01,
                    'filter_ncoa_02' => $this->quote->filter_ncoa_02,
                    'filter_ncoa_03' => $this->quote->filter_ncoa_03,
                    'filter_ncoa_04' => $this->quote->filter_ncoa_04,
                    'filter_ncoa_05' => $this->quote->filter_ncoa_05,
                    'filter_ncoa_06' => $this->quote->filter_ncoa_06,
                    'filter_ncoa_07' => $this->quote->filter_ncoa_07,
                    'filter_ncoa_08' => $this->quote->filter_ncoa_08,
                    'filter_cass_02' => $this->quote->filter_cass_02,
                    'filter_cass_03' => $this->quote->filter_cass_03,
                    'filter_cass_04' => $this->quote->filter_cass_04,
                    'filter_cass_05' => $this->quote->filter_cass_05,
                    'filter_cass_06' => $this->quote->filter_cass_06,
                    'filter_cass_07' => $this->quote->filter_cass_07,
                    'filter_cass_08' => $this->quote->filter_cass_08,
                    'filter_cass_09' => $this->quote->filter_cass_09,
                    'filter_cass_10' => $this->quote->filter_cass_10,
                ],
                $this->quote->mailing_agent?->toArray() ?? [null],
                $this->quote->permit_holder?->toArray() ?? [null],
                $this->quote->prepared_for?->toArray() ?? [null],
                $this->quote->column_mapping?->toArray() ?? [null],
            )
        );
    }

    /**
     * Use this web service call to update the object returned with the “Quote”, e.g., Class of Mail, Piece Size, etc... It
     * is necessary to make a call to this web service before calling the Presort web service. Otherwise, the Presort
     * web service will not know what Class of Mail or Piece Size you want to use for the presort.
     *
     * @param AccuzipQuote $quote
     */
    public function __construct(
        private readonly AccuzipQuote $quote,
    )
    {}
}
