<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accuzip_quotes', function (Blueprint $table) {
            $table->id();
            $table->string('source_disk')->default('public');
            $table->string('source_filepath');

            $table->string('guid')->nullable(); // not populated until upload complete=true
            $table->integer('total_records')->default(0);
            $table->integer('total_presort_records')->default(0);

            $table->boolean('upload_complete')->default(0);
            $table->boolean('do_cass')->default(1);
            $table->boolean('cass_certification_complete')->default(0);
            $table->boolean('do_ncoa')->default(1);
            $table->boolean('ncoa_link_certification_complete')->default(0);
            $table->boolean('do_dups')->default(1);
            $table->boolean('duplicate_detection_complete')->default(0);
            $table->boolean('do_presort')->default(1);
            $table->boolean('presort_complete')->default(0);

            $table->string('print_ready_filepath')->nullable();
            $table->string('usps_pdf_filepath')->nullable();
            $table->string('maildat_filepath')->nullable();

            $table->string('presort_class')->nullable();
            $table->integer('drop_zip')->nullable();
            $table->string('piece_size')->nullable();
            $table->timestamp('mail_date')->nullable();
            $table->string('mail_permit_number')->nullable();
            $table->string('statement_number')->nullable();

            $table->decimal('piece_height', 8, 4)->default(0)->nullable();
            $table->decimal('piece_length', 8, 4)->default(0)->nullable();
            $table->decimal('piece_thickness', 8, 4)->default(0)->nullable();
            $table->decimal('piece_weight', 8, 4)->default(0)->nullable();

            $table->string('tray_type')->nullable();
            $table->string('min1ft')->nullable();
            $table->string('max1ft')->nullable();
            $table->string('min2ft')->nullable();
            $table->string('max2ft')->nullable();

            $table->json('mailing_agent')->nullable();
            $table->json('permit_holder')->nullable();
            $table->json('prepared_for')->nullable();
            $table->json('column_mapping')->nullable();

            $table->boolean('print_barcode')->default(1);
            $table->boolean('print_imb')->default(1);
            $table->boolean('print_reverse')->default(0);
            $table->string('machinability')->default('MACHINABLE');
            $table->string('mail_permit_type')->default('PROFIT');
            $table->string('mail_pay_method')->default('IMPRINT');
            $table->boolean('include_non_zip4')->default(0);
            $table->boolean('include_crrt')->default(0);
            $table->boolean('political_mail')->default(0);
            $table->boolean('election_mail')->default(0);
            $table->boolean('maildat_pdr')->default(1);

            $table->boolean('coa_flag_only')->default(0); //COA represents: A match to a Move in the NCOALink data that would change the original address to the new address. Set 'coa_flag_only' to 1 and the CASS Certified Address will not be changed to a COA value.  Only the following fields will be updated ffapplied_; matchflag_; movedate_; movetype_; nxi_; ank_.  The standardized address fields will be left untouched.
            $table->boolean('filter_ncoa_01')->default(0); //1=Exclude; 0 or Missing = Include: Moved - COA Matches
            $table->boolean('filter_ncoa_02')->default(0); //1=Exclude; 0 or Missing = Include: Moved - New Address cannot be confirmed
            $table->boolean('filter_ncoa_03')->default(0); //1=Exclude; 0 or Missing = Include: Moved - Left No Forwarding
            $table->boolean('filter_ncoa_04')->default(0); //1=Exclude; 0 or Missing = Include: Moved - Foreign Country
            $table->boolean('filter_ncoa_05')->default(0); //1=Exclude; 0 or Missing = Include: Moved - New State
            $table->boolean('filter_ncoa_06')->default(0); //1=Exclude; 0 or Missing = Include: Individual Match
            $table->boolean('filter_ncoa_07')->default(0); //1=Exclude; 0 or Missing = Include: Family Match
            $table->boolean('filter_ncoa_08')->default(0); //1=Exclude; 0 or Missing = Include: Business Match
            
            $table->boolean('filter_cass_02')->default(0); //1=Exclude; 0 or Missing = Include: Unit number provided but not verified
            $table->boolean('filter_cass_03')->default(0); //1=Exclude; 0 or Missing = Include: Unit number missing from known high-rise address
            $table->boolean('filter_cass_04')->default(0); //1=Exclude; 0 or Missing = Include: Vacant
            $table->boolean('filter_cass_05')->default(0); //1=Exclude; 0 or Missing = Include: Business address
            $table->boolean('filter_cass_06')->default(0); //1=Exclude; 0 or Missing = Include: Private Mail Box address
            $table->boolean('filter_cass_07')->default(0); //1=Exclude; 0 or Missing = Include: Address not valid
            $table->boolean('filter_cass_08')->default(0); //1=Exclude; 0 or Missing = Include: Missing address element(s)
            $table->boolean('filter_cass_09')->default(0); //1=Exclude; 0 or Missing = Include: Foreign
            $table->boolean('filter_cass_10')->default(0); //1=Exclude; 0 or Missing = Include: Military Addresses
            
            $table->decimal('postage', 12, 2)->default(0);
            $table->decimal('postage_saved', 12, 2)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accuzip_quotes');
    }
};
